/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.applier;

import com.ferreusveritas.dynamictrees.api.applier.Applier;
import com.ferreusveritas.dynamictrees.api.applier.PropertyApplier;
import com.ferreusveritas.dynamictrees.api.applier.PropertyApplierResult;
import com.ferreusveritas.dynamictrees.api.applier.VoidApplier;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.util.LazyValue;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;

public final class JsonPropertyApplier<O, V>
extends PropertyApplier<O, V, JsonElement> {
    private final LazyValue<JsonDeserialiser<V>> deserialiser = LazyValue.supplied(() -> JsonDeserialisers.getOrThrow(valueClass));

    public JsonPropertyApplier(String key, Class<O> objectClass, Class<V> valueClass, VoidApplier<O, V> propertyApplier) {
        this(key, objectClass, valueClass, (Applier<O, V>)propertyApplier);
    }

    public JsonPropertyApplier(String key, Class<O> objectClass, Class<V> valueClass, Applier<O, V> applier) {
        super(key, objectClass, applier);
    }

    @Override
    @Nullable
    protected PropertyApplierResult applyIfShould(O object, JsonElement input, Applier<O, V> applier) {
        if (JsonDeserialisers.JSON_NULL.deserialise(input).success()) {
            return JsonDeserialisers.JSON_NULL.deserialise(input).map(value -> this.applier.apply(object, null)).orElseApply(PropertyApplierResult::failure, PropertyApplierResult::addWarnings, null);
        }
        return this.deserialiser.get().deserialise(input).map(value -> this.applier.apply(object, value)).orElseApply(PropertyApplierResult::failure, PropertyApplierResult::addWarnings, null);
    }
}

